Insert into sts_typ (site_cd,			sts_typ_cat_cd,		sts_typ_typ_cd,		sts_typ_desc,		audit_user,	audit_date)
Select				cf_site.site_cd,	'WORK',				'ACKNOWLEDGEMENT', 'Acknowledgement',	'admin',	getdate()
From cf_site
GO

Insert into sts_typ (site_cd,			sts_typ_cat_cd,		sts_typ_typ_cd,		sts_typ_desc,		audit_user,	audit_date)
Select				cf_site.site_cd,	'WORK',				'REWORK', 'Rework',	'admin',	getdate()
From cf_site
GO


INSERT INTO wrk_sts (
    site_cd,
    wrk_sts_cat_cd,
    wrk_sts_typ_cd,
    wrk_sts_status,
    wrk_sts_desc,
    wrk_sts_wo_limit,
    wrk_sts_email_flag,
    wrk_sts_disable_flag,
    audit_user,
    audit_date,
    wrk_sts_auto_send,
    wrk_sts_template,
    wrk_sts_tim_crd,
    wrk_sts_email_org,
    wrk_sts_cm_ack_req,
    wrk_sts_pm_ack_req
)
SELECT
    cs.site_cd,
    'WORK',
    'ACKNOWLEDGEMENT',
    'ACK',
    'Acknowledge',
    NULL,
    '0',
    '0',
    'admin',
    GETDATE(),
    '0',
    NULL,
    '0',
    '0',
    '0',
    '0'
FROM cf_site cs
WHERE NOT EXISTS (
    SELECT 1
    FROM wrk_sts ws
    WHERE ws.site_cd = cs.site_cd
      AND ws.wrk_sts_status = 'ACK'
);
GO

INSERT INTO wrk_sts (
    site_cd,
    wrk_sts_cat_cd,
    wrk_sts_typ_cd,
    wrk_sts_status,
    wrk_sts_desc,
    wrk_sts_wo_limit,
    wrk_sts_email_flag,
    wrk_sts_disable_flag,
    audit_user,
    audit_date,
    wrk_sts_auto_send,
    wrk_sts_template,
    wrk_sts_tim_crd,
    wrk_sts_email_org,
    wrk_sts_cm_ack_req,
    wrk_sts_pm_ack_req
)
SELECT
    cs.site_cd,
    'WORK',
    'REWORK',
    'RWK',
    'Rework',
    NULL,
    '0',
    '0',
    'admin',
    GETDATE(),
    '0',
    NULL,
    '0',
    '0',
    '0',
    '0'
FROM cf_site cs
WHERE NOT EXISTS (
    SELECT 1
    FROM wrk_sts ws
    WHERE ws.site_cd = cs.site_cd
      AND ws.wrk_sts_status = 'RWK'
);



Insert into usg_wrk (	site_cd,			usg_wrk_usr_grp,		usg_wrk_status,			usg_wrk_list,				usg_wrk_change,		usg_wrk_view,
						usg_wrk_edit,		usg_wrk_delete,			audit_user,				audit_date) 
Select					cf_site.site_cd,	usr_grp_usr_grp,		wrk_sts_status,			'0',						'0',				NULL,
						NULL,				NULL,					'admin',				getdate() 
From					usr_grp (NOLOCK), 
						wrk_sts (NOLOCK), 
						cf_site (NOLOCK)
Where					usr_grp.site_cd = wrk_sts.site_cd
AND						usr_grp.site_cd = cf_site.site_cd
And						wrk_sts_status IN ('ACK', 'RWK')
GO